<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    $campiAggiuntiviRicerca = array("tipoRicerca"=>"abbonamenti","status"=>104);
    if(isset($_GET["cerca"]) && $_GET["tipoRicerca"]=="abbonamenti") {
        $cercaAbbonamenti = $_GET["cerca"];
        $parametriRicerca = array("destinatario"=>filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_ADD_SLASHES));
    }
    else {
        $cercaAbbonamenti = "";
        $parametriRicerca = array();
    }
    
    $parametri = array("tabella"=>"geecEc_abbonamenti", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>array(),"ajax"=>false);
      
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"index.php");
?>
    <h4 class="mb-4 title">Abbonamenti</h4>
    <hr> 

    <div class="d-flex justify-content-between mb-3">
        <?php
            $ricerca->stampaSelectNumeroElementi($cercaAbbonamenti,$campiAggiuntiviRicerca);
            $ricerca->stampaFormRicerca($cercaAbbonamenti,$campiAggiuntiviRicerca);
        ?>
    </div>
    <div class="table-responsive table-sm">
    
        <?php
        
            if(isset($_GET["pag"])) {
                $ris = $ricerca->eseguiRicerca($_GET["pag"],"OR");
            }
            else {
                $ris = $ricerca->eseguiRicerca(1,"OR");
            }
            
            $colonne = array("ID","Cliente","Stato","Importo","Ultimo rinnovo","Data scadenza");
            $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
            $tabella->setTipo("normale");
            while($ordine = $ris->fetch_assoc()) {
                $nomeEscape    = filter_var($ordine["nome"],FILTER_SANITIZE_MAGIC_QUOTES);
                $ultimoRinnovo = date("d/m/Y",strtotime($ordine["ultimoRinnovo"]));
                $dataScadenza  = date("d/m/Y",strtotime($ordine["dataScadenza"]));
                
                if($ordine["pubblicato"]=="si") {
                    $azioni = array("modifica"=>"dettagliOrdine.php?id={$ordine["id"]}");
                }
                else {
                    $azioni = array("modifica"=>"dettagliOrdine.php?id={$ordine["id"]}");
                }
                $tabella->aggiungiNuovaRiga(array($ordine["id"],"<a href=\"dettagliordine.php?id={$ordine["id"]}\"><b>".$ordine["nome"]."</b></a>",$ordine["stato"],$ordine["importo"],$ultimoRinnovo,$dataScadenza),$azioni);
            }
            $tabella->stampa("rigaProdotto",0);
            $ricerca->stampaPaginazione(true,"index.php");
        ?>
    </div>